//DESCRIPTION:Aus Tabellen werden VCARD-QR-Codes erzeugt und eingefärbt. Die Farbe kann dynamisch geändert werden
//AUTHOR:SteigArt | Daniel Steiger (2025-06-2)
//Version: 5.1.3
//STATUS:Aktiv
/**SOURCE: 
 */
/**DEPENDENCY:  
 * Tabelle mit dem Namen "qrdata" im Dokument vorhanden (als Snippet beigefügt)
 */
/**USAGE:
Datentabelle für VCARD aus dem begefügten Snippet ausfüllen. Skript starten und QR-Codes werden erstellt. Da die Standardfarbzuweisung nicht dynamisch ist, muss die Farbe mit einem Workaround geändert werden.
Die Farbe wird als Farbeffekt überlagert.
*/
/**CHANGELOG: 
 * Fehlerbehebung: QR-Code ändert die Farbe nicht, weil das Objektformat "einfacher Objektrahmen" oder "einfacher Textrahmen" zugewiesen ist. Die Zuweisung des Objektformats wrird nun früher vorgenommen und die Farbe wird überschrieben.
 * Version 4.5.1:   Formularabfrage für die QR-Datentabelle erstellt. Die Abfrage funktioniert, sie wird aber noch nicht verarbeitet
 * Version 4.5.2:   Die QR-Datentabelle soll automatisch erstellt werden, wenn sie nicht vorhanden ist. 
 *                  Wenn keine Datentabelle vorhanden ist, wird zusätzlich gefragt, ob eine neue Tabelle erstellt werden soll.
 *                  Automatische Erstellung der Datentabelle mit den Vorgaben.
 * Version 5.1.3:   Fehler beheben: Wenn in den Standardeinstellungen eine Linienfarbe ausgewählt ist, soll sie nicht übernommen werden.
 */
/**ROADMAP:
 */


if (app.documents.length == 0) {
    alert("Zuerst ein Dokument öffnen, vor dem Start des Scripts");
} else {
    var qrdataTab = qrdataTabelle();
    alert("Das Skript ist beendet");
}

/*FUNKTION: Startpunkt, zuerst wird geprüft ob eine Tabelle vorhanden ist -------------------------------------------------------------*/
function qrdataTabelle(){
    var dok = app.activeDocument;
    var qrDataExists = false // Variable zur Feststellung, ob das Textfraem gefunden wurde

    // Alle Textramen finden
    for(var i = 0; i<dok.textFrames.length; i++){
        var foundTextFrame = dok.textFrames[i];

        // Nur Textframes mit dem Namen qrdata
        if(foundTextFrame.name === "qrdata"){
            qrDataExists = true;
            var qrdataID = foundTextFrame.id;

            //Seitenzahl in der die Tabelle ist
            var dataTablePage = foundTextFrame.parent.pages[0].name;

            // qrdata-Tabelle auslesen
            qrCodeContent(qrdataID, dataTablePage); //Funktion zum auslesen der qrdatas
        }
    }

    // Prüfen ob das Texframe qrdata vorhanden ist
    if(!qrDataExists){
        //Dialog erstellen, ob eine neue Tabelle erstellt werden soll
        var dlg = new Window('dialog', 'Keine QR-Datentabelle gefunden', undefined, {closeButton: true});
        dlg.add('statictext', undefined, 'Keine Tabelle mit den VCARD-Vorgaben vorhanden.');
        dlg.add('statictext', undefined, 'Soll eine neue QR-Datentabelle erstellt werden?');
        var btnGroup = dlg.add('group');
        btnGroup.orientation = 'row';
        var btnYes = btnGroup.add('button', undefined, 'Ja');
        var btnNo = btnGroup.add('button', undefined, 'Nein');
        btnNo.onClick = function() {
            dlg.close();
            alert("Das Skript wird beendet, da keine QR-Datentabelle erstellt wurde.");
            exit(); // Skript beenden, wenn der Benutzer "Nein" klickt
        };
        btnYes.onClick = function() {
            dlg.close();
            // Hier kannst du die Funktion zum Erstellen der Tabelle aufrufen, z.B.:
            createQRDataTableV2(); // Funktion zum Erstellen der QR-Datentabelle
        };
        var dlgResult = dlg.show(); // Dialog anzeigen
    }
}

//FUNKTION: Hauptfunktion zum erstellen des QR-Codes ---------------------------------------------------------------------------------
function qrCodeContent(textFrameID, dataTablePage){
    var dok = app.activeDocument;
    var qrDataTabID = textFrameID;
    var qrPosition = [5,5,30,30]; // Standardposition bei neuem Code
    var qrPage = app.activeWindow.activePage.documentOffset;


    // Die Tabelle im Textframe "qrdata" auswählen
    var tab = dok.textFrames.itemByID(qrDataTabID).tables[0];
    // alert("Inhalt der ersten Tabellenzelle: " + tab.cells[0].contents);
    tab.cells[0].contents = "ID" + qrDataTabID;

    // Variable Objekte
    var alloStyles = dok.objectStyles;
    var oStyleName = "QR-code";
    var oStylesYes = "";
    var qrBegin = "BEGIN:VCARD\nVERSION:3.0";
    var qrEnd = "END:VCARD";
    var qrcontent = "";
    
    // Durchsuchen der Zelle nach dem gesuchten Inhalt
    for (var i = 0; i < tab.cells.length; i++){
        var cell = tab.cells[i];
        if(cell.isValid){
            var num = i+1
            if(cell.contents == "Name") qrName = tab.cells[num].contents;
            if(cell.contents == "Vorname") qrVorname = tab.cells[num].contents;
            if(cell.contents == "Firma") qrFirma = tab.cells[num].contents;
            if(cell.contents == "Titel") qrTitel = tab.cells[num].contents; // Achtung Verwirrung: Titel wird in VCARD als Berufsbezeichnung verwendet. Der eigentliche Titel steht unter N: 
            if(cell.contents == "Berufsbez.") qrBezeichn = tab.cells[num].contents;
            if(cell.contents == "Abteilung") qrAbteil = tab.cells[num].contents;
            if(cell.contents == "Ort G") qrOrtG = tab.cells[num].contents;
            if(cell.contents == "Adresse G") qrAdrG = tab.cells[num].contents;
            if(cell.contents == "PLZ G") qrPLZG = tab.cells[num].contents;
            if(cell.contents == "Land G") qrLandG = tab.cells[num].contents;
            if(cell.contents == "Adresse P") qrAdrP = tab.cells[num].contents;
            if(cell.contents == "PLZ P") qrPLZP = tab.cells[num].contents;
            if(cell.contents == "Ort P") qrOrtP = tab.cells[num].contents;
            if(cell.contents == "Land P") qrLandP = tab.cells[num].contents;
            if(cell.contents == "Mail G") qrEmailWork = tab.cells[num].contents;
            if(cell.contents == "Mail P") qrEmailPriv = tab.cells[num].contents;
            if(cell.contents == "Zentrale") qrTelMain = tab.cells[num].contents;
            if(cell.contents == "Direkt") qrTelDirekt = tab.cells[num].contents;
            if(cell.contents == "Mobile") qrTelMobile = tab.cells[num].contents;
            if(cell.contents == "Fax") qrTelFax = tab.cells[num].contents;
            if(cell.contents == "Homepage") qrURL = tab.cells[num].contents;
            if(cell.contents == "Privat") qrTelPrivat = tab.cells[num].contents;
            if(cell.contents == "Farbe") qrColor = tab.cells[num].fillColor.name;
        } 
        else{
            alert("Keine Tabellenzellen vorhanden.");
        }
        
    }
        // QR-Code zusammensetzen
        var codecontent = qrBegin;
        // codecontent += "\nN:" + qrName + ";" + qrVorname;
        
        codecontent += "\nN:" + qrName + ";" + qrVorname + ";;" + qrTitel;
        codecontent += "\nFN:"+qrTitel + qrVorname + " " + qrName;
        codecontent += "\nTITLE:" + qrBezeichn; // Achtung Verwirrung: Titel wird in VCARD als Berufsbezeichnung verwendet. Der eigentliche Titel steht unter N:
        codecontent += "\nORG:" + qrFirma + ";" + qrAbteil;
        if(qrOrtG != ""){
            codecontent += "\nADR;TYPE=work:" + ";;" + qrAdrG + ";" + qrOrtG + ";;" + qrPLZG + ";" + qrLandG;
        }
        if(qrOrtP != ""){
            codecontent += "\nADR;TYPE=home:" + ";;" + qrAdrP + ";" + qrOrtP + ";;" + qrPLZP + ";" + qrLandP;
        }
        codecontent += "\nTEL;TYPE=main:" + qrTelMain;
        codecontent += "\nTEL;TYPE=work:" + qrTelDirekt;
        codecontent += "\nTEL;TYPE=cell:" + qrTelMobile;
        codecontent += "\nTEL;TYPE=home:" + qrTelPrivat;
        codecontent += "\nTEL;TYPE=fax:" + qrTelFax;
        codecontent += "\nEMAIL;TYPE=work:" + qrEmailWork;
        codecontent += "\nEMAIL;TYPE=home:" + qrEmailPriv;
        codecontent += "\nURL:" + qrURL;
        codecontent += "\n" + qrEnd;
          
        // prüfen, ob ein Objektformat für QR-Codes vorhanden ist
        var qrCodeData = qrCodeExist(textFrameID);

        //Falls ein QR-Code gefunden wurde, zeigen wir die Informationen an
        if(qrCodeData.qrCodeFound){
            qrPosition = qrCodeData.qrFramePosition;
            var qrCodeObjectFormatName = qrCodeData.qrObjectStyleName;
            qrPage = parseInt(qrCodeData.qrFramePage-1);
        }else{
            // qrPage = dataTablePage-1;
            qrPage = parseInt(dataTablePage, 10)-1;
        }

        // Bildbox oberhalb erstellen
        var qrSel = dok.pages[qrPage].rectangles.add();

        // Rahmenfarbe auf 0 setzen, damit keine Farbe zugewiesen ist
        qrSel.strokeWeight = 0;

        // QR-Codebox erstellen mit ausgewäahltem Inhalt befüllen
        qrSel.createPlainTextQRCode (codecontent);

        // QR-Code Position
        qrSel.geometricBounds = qrPosition;
        qrSel.name = "VCARD-CodeID" + textFrameID;
        qrSel.fit(FitOptions.PROPORTIONALLY); // Inhalt proportional zum Rahmen anpassen
        qrSel.fit(FitOptions.CENTER_CONTENT); // Inhalt im Rahmen zentrieren

        //Prüfen ob Objektformat vorhanden ist
        if(qrCodeData.qrObjectStyleName != null){
            qrSel.appliedObjectStyle = dok.objectStyles.itemByName(qrCodeObjectFormatName);
        }
        
        // QR-Code mittels Effekt einfärben
        qrSel.transparencySettings.innerGlowSettings.applied = true; // Effekt aktivieren
        qrSel.transparencySettings.innerGlowSettings.blendMode = BlendMode.NORMAL; //Füllmodus
        qrSel.transparencySettings.innerGlowSettings.effectColor = qrColor; // Farbe wählen
        qrSel.transparencySettings.innerGlowSettings.noise = 0; // Rauschen auf 0 gesetzt
        qrSel.transparencySettings.innerGlowSettings.opacity = 100; // Deckkraft auf 100%
        qrSel.transparencySettings.innerGlowSettings.size = 50; //Grösse auf 50, ein grösserer Wert erzeugt einen JS-Fehler
        qrSel.transparencySettings.innerGlowSettings.spread = 100; // Abschwächung auf 100%
        qrSel.transparencySettings.innerGlowSettings.technique = GlowTechnique.PRECISE; // Technik auf Präzise
        qrSel.strokeWeight = 0;
        qrSel.strokeColor = app.activeDocument.swatches.itemByName("None");
        qrSel.fillColor = app.activeDocument.swatches.itemByName("None");
        
        // alert("QR-Codes wurden erstellt bzw. aktualisiert." );
    }

// Funktion, um zu prüfen, ob bereits QR-Codes existieren und die relevanten Daten zurückzugeben --------------------------------------------
function qrCodeExist(textFrameID, objectStyleName){
    var dok = app.activeDocument;
    var qrCodeName = "VCARD-CodeID" + textFrameID;
    var qrCodeData = {
        qrCodeFound: false,
        qrFramePosition: null,
        qrFramePage: null,
        qrObjectStyleName: null
    };

    // Durchlaufe alle Rechtecke im Dokument
    for (var r = 0; r < dok.rectangles.length; r++) {
        var qrFrame = dok.rectangles[r];

        // Prüfen, ob der Name des Rechtecks "VCARD-QRcode" ist
        if (qrFrame.name == qrCodeName) {
            qrCodeData.qrCodeFound = true;

            // Position des Rechtecks auslesen
            qrCodeData.qrFramePosition = qrFrame.geometricBounds;

            // Seite des Rechtecks auslesen und sicherstellen, dass es auf einer Seite ist
            if (qrFrame.parentPage != null) {
                qrCodeData.qrFramePage = qrFrame.parentPage.name;
            }

            // Prüfen, ob dem Rechteck ein Objektformat zugewiesen ist
            var qrobjectStyle = qrFrame.appliedObjectStyle;

            if(qrobjectStyle.name == "[Einfacher Grafikrahmen]" || qrobjectStyle.name == "[Einfacher Textrahmen]"){
                qrCodeData.qrObjectStyleName = "[Ohne]"; 
            }else{
                // Wenn ein eigenes Objektformat zugewiesen wurde, soll es auch wieder verwendet werden
                qrCodeData.qrObjectStyleName = qrobjectStyle.name;
            }
            // Vorhandene QR-Codebox löschen
            qrFrame.remove();

            // Nur der erste "VCARD-QRcode" benötigt daher Schleife beenden
            break;
        }
    }
    return qrCodeData;
}

/**Funktion: Erstellung einer neuen qrTabelle auf Basis eines Formulars  ------------------------------------------------------*/
function createQRDataTableV2() {
    var w = new Window('dialog {text: "QR-Code Datentabelle erstellen", orientation: "column", alignChildren:["fill","fill"], properties: {closeButton: false}}');
    w.main = w.add('group {preferredSize: [600, 500], alignChildren: ["left","fill"]}');
    w.stubs = w.main.add('listbox', undefined, ['Adressdaten', 'Telefon', 'Geschäft', 'Privat', 'Weitere']);
    w.stubs.preferredSize.width = 150;

    w.tabGroup = w.main.add('group {alignment: ["fill","fill"], orientation: "stack"}');
    
    //Tabs definieren
    w.tabs = [];

    w.tabs[0] = w.tabGroup.add('group');
        w.tabs[0].add('statictext {text: "Adressdaten"}');
        w.tabs[0].add('panel');
        w.tabs[0].add('statictext {text: "Vorname"}');
        var vornameField = w.tabs[0].add('edittext {text: "", preferredSize: [200, -1]}');
        // vornameField.characters = 20;
        w.tabs[0].add('statictext {text: "Nachname"}');
        var nachnameField = w.tabs[0].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[0].add('statictext {text: "Titel"}');
        var titelField = w.tabs[0].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[0].add('statictext {text: "Berufsbezeichnung"}');
        var berufField = w.tabs[0].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[0].add('statictext {text: "Abteilung"}');
        var abteilField = w.tabs[0].add('edittext {text: "", preferredSize: [200, -1]}');

    w.tabs[1] = w.tabGroup.add('group');
        w.tabs[1].add('statictext {text: "Telefonnummern"}');
        w.tabs[1].add('panel');
        w.tabs[1].add('statictext {text: "Telefon Zentrale"}');
        var telZentralField = w.tabs[1].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[1].add('statictext {text: "Telefon Direkt"}');
        var telDirektField = w.tabs[1].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[1].add('statictext {text: "Telefon Mobil"}');
        var telMobileField = w.tabs[1].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[1].add('statictext {text: "Telefon Privat"}');
        var telPrivatField = w.tabs[1].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[1].add('statictext {text: "Fax"}');
        var faxField = w.tabs[1].add('edittext {text: "", preferredSize: [200, -1]}');
    
    w.tabs[2] = w.tabGroup.add('group');
        w.tabs[2].add('statictext {text: "Geschäftsangaben"}');
        w.tabs[2].add('panel');
        w.tabs[2].add('statictext {text: "Firma"}');
        var firmaField = w.tabs[2].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[2].add('statictext {text: "Adresse"}');
        var adrGField = w.tabs[2].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[2].add('statictext {text: "PLZ"}');
        var plzGField = w.tabs[2].add('edittext {text: "", preferredSize: [80, -1]}');
        w.tabs[2].add('statictext {text: "Ort"}');
        var ortGField = w.tabs[2].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[2].add('statictext {text: "Land"}');
        var landGField = w.tabs[2].add('edittext {text: "", preferredSize: [200, -1]}');

    w.tabs[3] = w.tabGroup.add('group');
        w.tabs[3].add('statictext {text: "Privatangaben"}');
        w.tabs[3].add('panel');
        w.tabs[3].add('statictext {text: "Adresse"}');
        var adrPField = w.tabs[3].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[3].add('statictext {text: "PLZ"}');
        var plzPField = w.tabs[3].add('edittext {text: "", preferredSize: [80, -1]}');
        w.tabs[3].add('statictext {text: "Ort"}');
        var ortPField = w.tabs[3].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[3].add('statictext {text: "Land"}');
        var landPField = w.tabs[3].add('edittext {text: "", preferredSize: [200, -1]}');

    w.tabs[4] = w.tabGroup.add('group');
        w.tabs[4].add('statictext {text: "Weitere Angaben"}');
        w.tabs[4].add('panel');
        w.tabs[4].add('statictext {text: "E-Mail Geschäft"}');
        var emailGField = w.tabs[4].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[4].add('statictext {text: "E-Mail Privat"}');
        var emailPField = w.tabs[4].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[4].add('statictext {text: "Homepage"}');
        var homepageField = w.tabs[4].add('edittext {text: "", preferredSize: [200, -1]}');
        w.tabs[4].add('statictext {text: "Farbe"}');
        var colorField = w.tabs[4].add('dropdownlist {preferredSize: [200, -1]}');

        //Farboptionen
        // Farben aus dem aktuellen InDesign-Dokument auflisten
        var colorOptions = [];
        if (app.documents.length > 0) {
            var docColors = app.activeDocument.swatches;
            for (var i = 0; i < docColors.length; i++) {
            colorOptions.push(docColors[i].name);
            }
        } else {
            colorOptions = ["[Keine Farben im Dokument]"];
        }
        for (var i = 0; i < colorOptions.length; i++) {
            colorField.add('item', colorOptions[i]);
        }
        // Standardfarbe auswählen
        colorField.selection = 0; // Standardmäßig die erste Farbe auswählen

    //Buttons
    w.buttons = w.add('group {alignment: "right"}');
    var okayBtn = w.buttons.add('button {text: "OK"}');
    var cancelBtn = w.buttons.add('button {text: "Abbrechen"}');

    //STandard- und Abbrechen-Button festlegen
    w.defaultElement = okayBtn;
    w.cancelElement = cancelBtn;

for (var i = 0; i < w.tabs.length; i++) {
            w.tabs[i].orientation = 'column';
            w.tabs[i].alignChildren = 'fill';
            w.tabs[i].alignment = ['fill', 'fill'];
            w.tabs[i].visible = false;
        }

    w.stubs.onChange = showTab;

    function showTab() {
        if (w.stubs.selection !== null) {
            for (var i = w.tabs.length - 1; i >= 0; i--) {
                w.tabs[i].visible = false;
            }
            w.tabs[w.stubs.selection.index].visible = true;
        }
    }
    w.onShow = function() {
        w.stubs.selection = 0;
        showTab;
    }

    //Dialog anzeigen und Ergebnisse verarbeiten
    var result = w.show();

    if(result === 1){
        // alert("Du hast OK gedrückt. Dein Vorname lautet: " + vornameField.text);
        createTable(); // Tabelle erstellen
    }else{
        alert("Du hast Abbrechen gedrückt. Der Dialog wird geschlossen.");
        exit(); // Dialog schließen
    }

    function createTable(){
        var doc = app.activeDocument;

        // Neue Tabelle erstellen
        // Textframe auf der ersten Seite erstellen
        var qrDataTable = doc.pages[0].textFrames.add();

        qrDataTable.name = "qrdata"; // Name der Tabelle
        qrDataTable.geometricBounds = ["0", "-80", "66", "-5"]; // Position und Größe der Tabelle        

        var tab = qrDataTable.tables.add({bodyRowCount: 24, columnCount: 2}); // 22 Zeilen, 2 Spalten
        tab.columns[0].width = 25; // Erste Spalte 25pt breit
        tab.columns[1].width = 50; // Zweite Spalte 50pt
        tab.name = "QR-Daten"; // Name der Tabelle

        // Schriftgröße für alle Zellen auf 7pt setzen und Zellenrahmen auf 0pt
        for (var i = 0; i < tab.cells.length; i++) {
            tab.cells[i].texts[0].pointSize = 7;
            tab.cells[i].topEdgeStrokeWeight = 0;
            tab.cells[i].bottomEdgeStrokeWeight = 0;
            tab.cells[i].leftEdgeStrokeWeight = 0;
            tab.cells[i].rightEdgeStrokeWeight = 0;
        }

        // Tabellenzellen erstellen    
        tab.cells[0].contents = "ID"; // ID der Tabelle
        tab.cells[1].contents = "";
        tab.cells[2].contents = "Name";
        tab.cells[3].contents = nachnameField.text; // Nachname 
        tab.cells[4].contents = "Vorname";
        tab.cells[5].contents = vornameField.text; // Vorname
        tab.cells[6].contents = "Titel";
        tab.cells[7].contents = titelField.text; // Titel
        tab.cells[8].contents = "Berufsbez.";
        tab.cells[9].contents = berufField.text; // Berufsbezeichnung
        tab.cells[10].contents = "Abteilung";
        tab.cells[11].contents = abteilField.text; // Abteilung
        tab.cells[12].contents = "Zentrale";
        tab.cells[13].contents = telZentralField.text; // Telefon Zentrale
        tab.cells[14].contents = "Direkt";
        tab.cells[15].contents = telDirektField.text; // Telefon Direkt
        tab.cells[16].contents = "Mobile";
        tab.cells[17].contents = telMobileField.text; // Telefon Mobil
        tab.cells[18].contents = "Privat";
        tab.cells[19].contents = telPrivatField.text; // Telefon Privat
        tab.cells[20].contents = "Fax";
        tab.cells[21].contents = faxField.text; // Fax
        tab.cells[22].contents = "Firma";
        tab.cells[23].contents = firmaField.text; // Firma
        tab.cells[24].contents = "Adresse G";
        tab.cells[25].contents = adrGField.text; // Adresse Geschäft
        tab.cells[26].contents = "PLZ G";
        tab.cells[27].contents = plzGField.text; // PLZ Geschäft
        tab.cells[28].contents = "Ort G";
        tab.cells[29].contents = ortGField.text; // Ort Geschäft
        tab.cells[30].contents = "Land G";
        tab.cells[31].contents = landGField.text; // Land Geschäft
        tab.cells[32].contents = "Adresse P";
        tab.cells[33].contents = adrPField.text; // Adresse Privat
        tab.cells[34].contents = "PLZ P";
        tab.cells[35].contents = plzPField.text; // PLZ Privat
        tab.cells[36].contents = "Ort P";
        tab.cells[37].contents = ortPField.text; // Ort Privat
        tab.cells[38].contents = "Land P";
        tab.cells[39].contents = landPField.text; // Land Privat
        tab.cells[40].contents = "Mail G";
        tab.cells[41].contents = emailGField.text; // E-Mail Geschäft
        tab.cells[42].contents = "Mail P";
        tab.cells[43].contents = emailPField.text; // E-Mail Privat
        tab.cells[44].contents = "Homepage";
        tab.cells[45].contents = homepageField.text; // Homepage
        tab.cells[46].contents = "Farbe";

        //Schwarz als Standardfarbe wenn OHne gewählt wurde
        // tab.cells[47].fillColor = app.activeDocument.swatches.itemByName("Black");
        // alert("Farbe: " + colorField.selection.text);
        
        if(colorField.selection.text == "None"){
            tab.cells[47].fillColor = app.activeDocument.swatches.itemByName("Black");
        }else{
        tab.cells[47].fillColor = app.activeDocument.swatches.itemByName(colorField.selection.text);
        }

        //Rahmen der Textbox auf Tabelle setzen
        qrDataTable.fit(FitOptions.FRAME_TO_CONTENT);

        qrdataTabelle()
        }

}